/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class BloodThirstyModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileLaunchModifierHook,
ConditionalStatModifierHook,
InventoryTickModifierHook,
ModifierRemovalHook,
AttributesModifierHook,
TooltipModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "blood_thirsty");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.REMOVE, ModifierHooks.ATTRIBUTES, ModifierHooks.TOOLTIP, ModifierHooks.INVENTORY_TICK});
    }

    public int getPriority() {
        return 75;
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)Utils.bloodthirstyEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.bloodthirstyEffect.get()).apply(attacker, 100, effectLevel, true);
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putFloat(this.KEY, (float)(effectLevel + 1));
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        return stat == ToolStats.VELOCITY ? baseValue * (1.0f + BloodThirstyModifier.getBonus(living, Utils.bloodthirstyEffect, modifier.getLevel(), 16.0f) * tool.getMultiplier((INumericToolStat)ToolStats.VELOCITY)) : baseValue;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(15, ((TinkerEffect)Utils.bloodthirstyEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.bloodthirstyEffect.get()).apply(shooter, 100, effectLevel, true);
        }
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && isSelected) {
            ModDataNBT persistentData = tool.getPersistentData();
            if (((TinkerEffect)Utils.bloodthirstyEffect.get()).getLevel(holder) == -1) {
                persistentData.remove(this.KEY);
            }
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (slot == EquipmentSlot.MAINHAND && (boost = (double)(tool.getPersistentData().getFloat(this.KEY) * (float)modifier.getLevel() / 8.0f)) != 0.0) {
            consumer.accept(Attributes.f_22283_, new AttributeModifier(UUID.fromString("643c78a6-fb2e-405a-a33d-dde16edb70ee"), Attributes.f_22283_.m_22087_(), boost, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            float bonus = BloodThirstyModifier.getBonus((LivingEntity)player, Utils.bloodthirstyEffect, modifier.getLevel(), 16.0f);
            if (player != null && tooltipKey == TooltipKey.SHIFT && !harvest) {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.VELOCITY, (TagKey)TinkerTags.Items.RANGED, (float)bonus, tooltip);
            }
        }
    }
}

